<?php
session_start();
include "../config/db.php";

$error = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $kode = $_POST['kode'] ?? '';

    $stmt = $conn->prepare("SELECT id FROM verification_codes WHERE code=?");
    $stmt->bind_param("s", $kode);
    $stmt->execute();
    $res = $stmt->get_result();

    if ($res->num_rows > 0) {
        $_SESSION['user'] = $kode;
        header("Location: dashboard.php");
        exit;
    } else {
        $error = "Kode verifikasi salah.";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Masuk - ZoKids Edukasi Anak</title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Comic+Neue:wght@700&family=Poppins:wght@400;600&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="/edukasi_anak/assets/css/style1.css">

</head>
<body>

  <div class="navbar-zokids">
    <div class="brand">
      <h1>ZoKids</h1>
    </div>
  </div>

  <div class="login-card">
    <h4>Masuk ke ZoKids</h4>

    <?php if (!empty($error)) echo "<div class='alert alert-danger'>$error</div>"; ?>

    <form method="post">
      <div class="mb-3 text-start">
        <label for="kode" class="form-label">Kode Verifikasi</label>
        <input type="text" id="kode" name="kode" class="form-control" required>
      </div>
      <button class="btn btn-primary w-100" type="submit">Masuk</button>
    </form>
  </div>

  <footer>© 2025 ZoKids Edukasi Anak</footer>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
