<?php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: index.php");
    exit;
}
include "../config/db.php";
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Dashboard - ZoKids Edukasi Anak</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Comic+Neue:wght@700&family=Poppins:wght@400;600&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="/edukasi_anak/assets/css/style1.css">
  
</head>

<body class="dashboard">
  <!-- Navbar ceria -->
  <div class="navbar-zokids">
    <div class="brand">
      <h1>ZoKids</h1>
    </div>
    <a href="logout.php" class="btn btn-logout">Keluar</a>
  </div>


  <div class="dashboard-container container">
    <h4>Halo 👋</h4>
    <p>Pilih kategori yang ingin dipelajari:</p>
    
    <div class="row g-3">
      <?php
      $res = $conn->query("SELECT * FROM kategori ORDER BY id ASC");
      while ($kat = $res->fetch_assoc()):
      ?>
        <div class="col-6 col-md-4 col-lg-3">
          <a href="belajar.php?kategori=<?= urlencode($kat['nama_kategori']); ?>" class="text-decoration-none">
            <div class="kategori-card" style="background-color: <?= $kat['color'] ?: 'rgba(255,255,255,0.25)' ?>;">
              <?php if (!empty($kat['icon'])): ?>
                <img src="/edukasi_anak/assets/icons/<?= htmlspecialchars($kat['icon']); ?>" alt="<?= $kat['nama_kategori']; ?>">
              <?php else: ?>
                <img src="default.png" alt="default">
              <?php endif; ?>
              <span><?= $kat['nama_kategori']; ?></span>
            </div>
          </a>
        </div>
      <?php endwhile; ?>
    </div>

  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
  <footer>© 2025 ZoKids Edukasi Anak</footer>
</body>
</html>
