<?php
// create_admin.php
// --- Simple admin creation script ---
// Put this file in your project root (same level as config/)
// Open in browser once, create admin, then DELETE this file.

session_start();
include "config/db.php"; // pastikan path benar

$message = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $email    = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $password2 = $_POST['password2'] ?? '';

    if ($username === '' || $email === '' || $password === '') {
        $message = "Semua field harus diisi.";
    } elseif ($password !== $password2) {
        $message = "Password dan konfirmasi tidak cocok.";
    } else {
        // Cek apakah username sudah ada
        $stmt = $conn->prepare("SELECT id FROM users WHERE username = ?");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows > 0) {
            $message = "Username sudah digunakan. Pilih username lain.";
            $stmt->close();
        } else {
            $stmt->close();
            // Hash password
            $hash = password_hash($password, PASSWORD_DEFAULT);

            // Insert user dengan role = 'admin'
            $ins = $conn->prepare("INSERT INTO users (username, email, password, role) VALUES (?, ?, ?, 'admin')");
            $ins->bind_param("sss", $username, $email, $hash);

            if ($ins->execute()) {
                $message = "Akun admin berhasil dibuat. Silakan login di admin/index.php";
                // (opsional) redirect ke halaman login admin
                // header("Location: admin/index.php"); exit;
            } else {
                $message = "Gagal menyimpan data: " . $conn->error;
            }
            $ins->close();
        }
    }
}
?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <title>Create Admin - Edukasi Anak</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
  <div class="container" style="max-width:480px; margin-top:60px;">
    <div class="card shadow-sm p-4">
      <h4 class="mb-3">Buat Akun Admin</h4>

      <?php if ($message): ?>
        <div class="alert alert-info"><?= htmlspecialchars($message); ?></div>
      <?php endif; ?>

      <form method="post" novalidate>
        <div class="mb-3">
          <label class="form-label">Username</label>
          <input name="username" class="form-control" required value="<?= isset($username) ? htmlspecialchars($username) : ''; ?>">
        </div>

        <div class="mb-3">
          <label class="form-label">Email</label>
          <input name="email" type="email" class="form-control" required value="<?= isset($email) ? htmlspecialchars($email) : ''; ?>">
        </div>

        <div class="mb-3">
          <label class="form-label">Password</label>
          <input name="password" type="password" class="form-control" required>
        </div>

        <div class="mb-3">
          <label class="form-label">Konfirmasi Password</label>
          <input name="password2" type="password" class="form-control" required>
        </div>

        <button class="btn btn-primary w-100" type="submit">Buat Admin</button>
      </form>

      <hr class="my-3">
      <div class="text-muted small">
        Setelah akun dibuat, <strong>hapus file ini</strong> dari server untuk keamanan.
      </div>
    </div>
  </div>
</body>
</html>
