<?php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: index.php");
    exit;
}

include "../config/db.php";

$kategori = $_GET['kategori'] ?? null;

// ambil data kategori
$sqlKat = "SELECT * FROM kategori WHERE nama_kategori = '$kategori'";
$resKat = $conn->query($sqlKat);

if ($resKat->num_rows == 0) {
    die("Kategori tidak ditemukan!");
}

$rowKat = $resKat->fetch_assoc();
$kategori_id = $rowKat['id'];

// ambil materi sesuai kategori
$sqlMateri = "SELECT * FROM materi WHERE kategori_id = $kategori_id";
$resMateri = $conn->query($sqlMateri);

if ($resMateri->num_rows == 0): ?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Belajar <?= ucfirst($kategori); ?> - ZoKids</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Comic+Neue:wght@700&family=Poppins:wght@400;600&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="/edukasi_anak/assets/css/style1.css">
</head>
<body class="belajar">
  <div class="navbar-zokids">
    <div class="brand">
      <h1>ZoKids</h1>
    </div>
  </div>

  <div class="container d-flex flex-column justify-content-center align-items-center" style="min-height: 80vh;">
    <div class="card bg-white bg-opacity-50 p-4 rounded-4 shadow-lg text-center" style="max-width: 400px;">
<img src="../assets/img/empty-box.webp" alt="Tidak Ada Materi" 
     class="img-fluid mb-3 d-block mx-auto" 
     style="max-width:150px;">
      <h3 class="fw-bold text-warning mb-2">Oops!</h3>
      <p class="text-dark fw-semibold">Belum ada materi untuk kategori ini.</p>
      <a href="dashboard.php" class="btn btn-primary mt-2"><i class="bi bi-arrow-left-circle"></i> Kembali</a>
    </div>
  </div>

  <footer>© 2025 ZoKids Edukasi Anak</footer>
</body>
</html>
<?php exit; endif; ?>


<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Belajar <?= ucfirst($kategori); ?> - ZoKids</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Comic+Neue:wght@700&family=Poppins:wght@400;600&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
  <link rel="stylesheet" href="/edukasi_anak/assets/css/style1.css">
</head>


<body class="belajar">
  <!-- Navbar ceria -->
  <div class="navbar-zokids">
    <div class="brand">
      <h1>ZoKids</h1>
    </div>
    <a href="dashboard.php" class="btn btn-secondary"><i class="bi bi-box-arrow-left"></i></a>
  </div>

  <div class="container container-belajar position-relative z-2 mt-3">

    <h3 class="text-center text-black fw-bold text-shadow">Belajar <?= ucfirst($kategori); ?></h3>

    <div id="carouselExample" class="carousel slide mt-4" data-bs-ride="carousel">
      <div class="carousel-inner">
        <?php 
        $active = "active";
        $i = 0;
        while ($row = $resMateri->fetch_assoc()): 
          $i++;
        ?>
          <div class="carousel-item <?= $active; ?>">
            <div class="text-center">
              <img src="../assets/img/<?= $row['gambar']; ?>" 
                  class="d-block mx-auto mb-3 materi-img" 
                  alt="<?= $row['judul']; ?>">
              <h2><?= $row['judul']; ?></h2>

              <audio id="audio<?= $i; ?>" src="../assets/audio/<?= $row['audio']; ?>"></audio>

              <button id="btnPlay<?= $i; ?>" class="btn btn-primary btn-audio">
                <i class="bi bi-play-fill"></i>
              </button>
            </div>
          </div>
        <?php $active=""; endwhile; ?>
      </div>

      <button class="carousel-control-prev" type="button" data-bs-target="#carouselExample" data-bs-slide="prev">
        <span class="carousel-control-prev-icon"></span>
      </button>
      <button class="carousel-control-next" type="button" data-bs-target="#carouselExample" data-bs-slide="next">
        <span class="carousel-control-next-icon"></span>
      </button>
    </div>

  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

  <script>
    const audios = document.querySelectorAll("audio");
    const buttons = document.querySelectorAll(".btn-audio");

    buttons.forEach((btn, index) => {
      const audio = document.getElementById("audio" + (index+1));
      const icon = btn.querySelector("i");

      btn.addEventListener("click", () => {
        if (audio.paused) {
          audios.forEach(a => { a.pause(); a.currentTime = 0; });
          buttons.forEach(b => {
            b.classList.replace("btn-danger", "btn-primary");
            b.querySelector("i").classList.replace("bi-pause-fill", "bi-play-fill");
          });

          audio.play();
          icon.classList.replace("bi-play-fill", "bi-pause-fill");
          btn.classList.replace("btn-primary", "btn-danger");
        } else {
          audio.pause();
          icon.classList.replace("bi-pause-fill", "bi-play-fill");
          btn.classList.replace("btn-danger", "btn-primary");
        }
      });

      audio.addEventListener("ended", () => {
        icon.classList.replace("bi-pause-fill", "bi-play-fill");
        btn.classList.replace("btn-danger", "btn-primary");
      });
    });
  </script>
    <footer>© 2025 ZoKids Edukasi Anak</footer>
</body>
</html>
