<?php
session_start();
if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}
include "../config/db.php";

// === PROSES TAMBAH ===
if (isset($_POST['tambah'])) {
    $judul = $_POST['judul'];
    $kategori_id = $_POST['kategori_id'];
    $gambar = $audio = "";

    if (!empty($_FILES['gambar']['name'])) {
        $targetDir = "../assets/img/";
        $fileName = time() . "_" . basename($_FILES['gambar']['name']);
        if (move_uploaded_file($_FILES['gambar']['tmp_name'], $targetDir . $fileName)) $gambar = $fileName;
    }

    if (!empty($_FILES['audio']['name'])) {
        $targetDir = "../assets/audio/";
        $fileName = time() . "_" . basename($_FILES['audio']['name']);
        if (move_uploaded_file($_FILES['audio']['tmp_name'], $targetDir . $fileName)) $audio = $fileName;
    }

    $stmt = $conn->prepare("INSERT INTO materi (kategori_id, judul, gambar, audio) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("isss", $kategori_id, $judul, $gambar, $audio);
    $stmt->execute();
    $_SESSION['msg'] = "Materi berhasil ditambahkan!";
    header("Location: materi.php");
    exit;
}

// === PROSES HAPUS ===
if (isset($_GET['hapus'])) {
    $id = intval($_GET['hapus']);
    $res = $conn->query("SELECT * FROM materi WHERE id=$id");
    if ($res->num_rows > 0) {
        $m = $res->fetch_assoc();
        @unlink("../assets/img/" . $m['gambar']);
        @unlink("../assets/audio/" . $m['audio']);
        $conn->query("DELETE FROM materi WHERE id=$id");
    }
    $_SESSION['msg'] = "Materi berhasil dihapus!";
    header("Location: materi.php");
    exit;
}

// === PROSES UPDATE ===
if (isset($_POST['update'])) {
    $id = $_POST['id'];
    $judul = $_POST['judul'];
    $kategori_id = $_POST['kategori_id'];

    $res = $conn->query("SELECT * FROM materi WHERE id=$id");
    $old = $res->fetch_assoc();
    $gambar = $old['gambar'];
    $audio = $old['audio'];

    if (!empty($_FILES['gambar']['name'])) {
        $targetDir = "../assets/img/";
        $fileName = time() . "_" . basename($_FILES['gambar']['name']);
        if (move_uploaded_file($_FILES['gambar']['tmp_name'], $targetDir . $fileName)) {
            if (file_exists($targetDir . $old['gambar'])) unlink($targetDir . $old['gambar']);
            $gambar = $fileName;
        }
    }

    if (!empty($_FILES['audio']['name'])) {
        $targetDir = "../assets/audio/";
        $fileName = time() . "_" . basename($_FILES['audio']['name']);
        if (move_uploaded_file($_FILES['audio']['tmp_name'], $targetDir . $fileName)) {
            if (file_exists($targetDir . $old['audio'])) unlink($targetDir . $old['audio']);
            $audio = $fileName;
        }
    }

    $stmt = $conn->prepare("UPDATE materi SET kategori_id=?, judul=?, gambar=?, audio=? WHERE id=?");
    $stmt->bind_param("isssi", $kategori_id, $judul, $gambar, $audio, $id);
    $stmt->execute();
    $_SESSION['msg'] = "Materi berhasil diperbarui!";
    header("Location: materi.php");
    exit;
}

// === AMBIL DATA ===
$orderBy = "m.id DESC"; // default urutan
if (isset($_GET['sort'])) {
    if ($_GET['sort'] === 'asc') {
        $orderBy = "m.judul ASC";
    } elseif ($_GET['sort'] === 'desc') {
        $orderBy = "m.judul DESC";
    } elseif ($_GET['sort'] === 'kategori') {
        $orderBy = "k.nama_kategori ASC";
    }
}

$materi = $conn->query("SELECT m.*, k.nama_kategori 
                        FROM materi m 
                        JOIN kategori k ON m.kategori_id=k.id 
                        ORDER BY $orderBy");


// Edit mode jika klik tombol edit
$editData = null;
if (isset($_GET['edit'])) {
    $id = intval($_GET['edit']);
    $res = $conn->query("SELECT * FROM materi WHERE id=$id");
    $editData = $res->fetch_assoc();
}
$kategoriList = $conn->query("SELECT * FROM kategori");
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Kelola Materi - ZoKids</title>
<link rel="stylesheet" href="/edukasi_anak/assets/css/style1.css">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body class="dashboard">

<div class="navbar-zokids">
    <div class="brand"><h1>ZoKids Admin</h1></div>
    <a href="dashboard.php" class="btn btn-secondary"><i class="bi bi-box-arrow-left"></i></a>
</div>

<div class="dashboard-container">
<div class="container">

<h4 class="mb-3">Kelola Materi</h4>

<?php if (!empty($_SESSION['msg'])): ?>
<div class="alert alert-success"><?= $_SESSION['msg']; unset($_SESSION['msg']); ?></div>
<?php endif; ?>

<!-- Form Tambah / Edit -->
<div class="card p-3 mb-4 bg-light bg-opacity-75 rounded-4">
  <form method="post" enctype="multipart/form-data" class="text-start">
    <input type="hidden" name="id" value="<?= $editData['id'] ?? '' ?>">

    <div class="mb-3">
      <label class="form-label fw-semibold">Judul Materi</label>
      <input type="text" name="judul" class="form-control rounded-3" required
             value="<?= htmlspecialchars($editData['judul'] ?? '') ?>">
    </div>

    <div class="mb-3">
      <label class="form-label fw-semibold">Kategori</label>
      <select name="kategori_id" class="form-select rounded-3" required>
        <option value="">-- Pilih Kategori --</option>
        <?php while($k = $kategoriList->fetch_assoc()): ?>
          <option value="<?= $k['id'] ?>" <?= ($editData && $editData['kategori_id']==$k['id'])?'selected':'' ?>>
            <?= htmlspecialchars($k['nama_kategori']) ?>
          </option>
        <?php endwhile; ?>
      </select>
    </div>

    <div class="mb-3">
      <label class="form-label fw-semibold">Gambar</label><br>
      <?php if ($editData && $editData['gambar']): ?>
        <img src="../assets/img/<?= $editData['gambar'] ?>" width="80" class="rounded mb-2"><br>
      <?php endif; ?>
      <input type="file" name="gambar" class="form-control rounded-3">
    </div>

    <div class="mb-3">
      <label class="form-label fw-semibold">Audio</label><br>
      <?php if ($editData && $editData['audio']): ?>
        <audio controls style="width:100%">
          <source src="../assets/audio/<?= $editData['audio'] ?>" type="audio/mpeg">
        </audio>
      <?php endif; ?>
      <input type="file" name="audio" class="form-control rounded-3 mt-1">
    </div>

    <?php if ($editData): ?>
      <div class="d-flex justify-content-center gap-2 mt-3">
        <button type="submit" name="update" class="btn btn-primary rounded-3 px-4 py-2">
          <i class="bi bi-save"></i> Save
        </button>
        <a href="materi.php" class="btn btn-secondary rounded-3 px-4 py-2">
          <i class="bi bi-x-circle"></i> Batal
        </a>
      </div>
    <?php else: ?>
      <div class="text-center mt-3">
        <button type="submit" name="tambah" class="btn btn-primary rounded-3 px-4 py-2" style="width:auto;">
          <i class="bi bi-plus-circle"></i> Tambah
        </button>
      </div>
    <?php endif; ?>
  </form>
</div>

<!-- Filter & Sort -->
<div class="d-flex justify-content-between align-items-center mb-3 flex-wrap gap-2">
  <h5 class="mb-0 text-warning fw-bold">Daftar Materi</h5>
  <form method="get" class="d-flex align-items-center gap-2">
    <select name="sort" class="form-select form-select-sm rounded-3" onchange="this.form.submit()">
      <option value="">Urutkan Berdasarkan</option>
      <option value="kategori" <?= (isset($_GET['sort']) && $_GET['sort']=='kategori')?'selected':'' ?>>Kategori (A-Z)</option>
      <option value="asc" <?= (isset($_GET['sort']) && $_GET['sort']=='asc')?'selected':'' ?>>Judul A-Z</option>
      <option value="desc" <?= (isset($_GET['sort']) && $_GET['sort']=='desc')?'selected':'' ?>>Judul Z-A</option>
    </select>
    <?php if (isset($_GET['edit'])): ?>
      <input type="hidden" name="edit" value="<?= htmlspecialchars($_GET['edit']) ?>">
    <?php endif; ?>
  </form>
</div>


<!-- Tabel Materi -->
<div class="card bg-white bg-opacity-75 rounded-4 p-3 shadow-sm">
  <div class="table-responsive">
    <table class="table table-bordered align-middle text-center mb-0">
      <thead class="table-warning">
        <tr>
          <th style="width: 60px;">No</th>
          <th>Kategori</th>
          <th>Judul</th>
          <th>Gambar</th>
          <th>Audio</th>
          <th style="width: 110px;">Aksi</th>
        </tr>
      </thead>
      <tbody>
        <?php 
        $no = 1;
        while($row = $materi->fetch_assoc()): ?>
          <tr>
            <td><?= $no++; ?></td>
            <td><?= htmlspecialchars($row['nama_kategori']) ?></td>
            <td><?= htmlspecialchars($row['judul']) ?></td>
            <td>
              <?php if (!empty($row['gambar']) && file_exists("../assets/img/" . $row['gambar'])): ?>
                <img src="../assets/img/<?= htmlspecialchars($row['gambar']); ?>" width="60" class="rounded">
              <?php else: ?><span class="text-muted small">Tidak ada</span><?php endif; ?>
            </td>
            <td>
              <?php if (!empty($row['audio']) && file_exists("../assets/audio/" . $row['audio'])): ?>
                <audio controls style="width:100px">
                  <source src="../assets/audio/<?= htmlspecialchars($row['audio']); ?>" type="audio/mpeg">
                </audio>
              <?php else: ?><span class="text-muted small">Tidak ada</span><?php endif; ?>
            </td>
            <td>
              <div class="d-flex justify-content-center flex-wrap gap-1">
                <a href="?edit=<?= $row['id'] ?>" class="btn btn-warning btn-sm d-flex align-items-center justify-content-center" title="Edit">
                  <i class="bi bi-pencil"></i>
                </a>
                <a href="?hapus=<?= $row['id'] ?>" class="btn btn-danger btn-sm d-flex align-items-center justify-content-center"
                   onclick="return confirm('Yakin ingin hapus?');" title="Hapus">
                  <i class="bi bi-trash"></i>
                </a>
              </div>
            </td>
          </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</div>


</div>
</div>

<footer>© 2025 ZoKids — Edukasi Anak Indonesia</footer>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
