<?php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login.php");
  exit;
}
include "../config/db.php";

$message = "";

/* ====== TAMBAH KODE ====== */
if (isset($_POST['tambah'])) {
  $kode = trim($_POST['kode'] ?? '');
  if ($kode === '') {
    $message = "Kode verifikasi tidak boleh kosong.";
  } else {
    $stmt = $conn->prepare("INSERT INTO verification_codes (code) VALUES (?)");
    $stmt->bind_param("s", $kode);
    if ($stmt->execute()) {
      $message = "Kode verifikasi <b>$kode</b> berhasil ditambahkan.";
    } else {
      $message = "Gagal menambah kode.";
    }
  }
}

/* ====== HAPUS KODE ====== */
if (isset($_GET['hapus'])) {
  $id = intval($_GET['hapus']);
  $conn->query("DELETE FROM verification_codes WHERE id=$id");
  $message = "Kode berhasil dihapus.";
}

/* ====== UPDATE KODE ====== */
if (isset($_POST['update_kode'])) {
  $id = intval($_POST['id']);
  $kode_baru = trim($_POST['kode']);
  if ($kode_baru === '') {
    $message = "Kode tidak boleh kosong.";
  } else {
    $stmt = $conn->prepare("UPDATE verification_codes SET code=? WHERE id=?");
    $stmt->bind_param("si", $kode_baru, $id);
    if ($stmt->execute()) {
      $message = "Kode berhasil diperbarui menjadi <b>$kode_baru</b>.";
    } else {
      $message = "Gagal memperbarui kode.";
    }
  }
}

/* ====== AMBIL DATA ====== */
$kodeData = $conn->query("SELECT * FROM verification_codes ORDER BY created_at DESC");
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Kelola Kode Verifikasi - ZoKids</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
  <link rel="stylesheet" href="/edukasi_anak/assets/css/style1.css">
</head>
<body class="dashboard">

<!-- Navbar -->
<div class="navbar-zokids">
  <div class="brand"><h1>ZoKids Admin</h1></div>
  <a href="dashboard.php" class="btn btn-secondary"><i class="bi bi-box-arrow-left"></i></a>
</div>

<div class="dashboard-container">
  <div class="container">
    <h4 class="mb-3">Kelola Kode Verifikasi</h4>

    <?php if ($message): ?>
      <div class="alert alert-info shadow-sm rounded-3"><?= $message ?></div>
    <?php endif; ?>

    <!-- Form Tambah / Edit -->
    <div class="card mb-4 p-3 bg-light bg-opacity-75 rounded-4">
    <form method="post" class="text-start" id="kodeForm">
      <input type="hidden" name="id" id="kode_id">

      <div class="mb-3">
        <label class="form-label fw-semibold text-start w-100">Kode Verifikasi</label>
        <input type="text" name="kode" id="kode_input" class="form-control rounded-3" required>
      </div>

      <div class="text-center mt-3">
        <button type="submit" name="tambah" id="submitBtn"
                class="btn btn-primary rounded-3 py-2 px-4">
          <i class="bi bi-plus-circle"></i> Tambah
        </button>

        <div class="d-none mt-2" id="editButtons">
          <button type="submit" name="update_kode" class="btn btn-primary rounded-3 py-2 px-4">
            <i class="bi bi-save"></i> Simpan
          </button>

          <button type="button" class="btn btn-secondary rounded-3 py-2 px-4" id="cancelEdit">
            <i class="bi bi-x-circle"></i> Batal
          </button>
        </div>
      </div>
    </form>

    </div>

    <!-- Daftar Kode -->
    <div class="card bg-white bg-opacity-75 rounded-4 p-3 shadow-sm">
      <div class="table-responsive">
        <table class="table table-bordered align-middle text-center mb-0">
          <thead class="table-warning">
            <tr>
              <th>ID</th>
              <th>Kode</th>
              <th>Tanggal Dibuat</th>
              <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            <?php while ($row = $kodeData->fetch_assoc()): ?>
            <tr>
              <td><?= $row['id'] ?></td>
              <td><?= htmlspecialchars($row['code']) ?></td>
              <td><?= $row['created_at'] ?></td>
              <td>
                <div class="d-inline-flex gap-1">
                  <button type="button" class="btn btn-warning btn-sm editBtn"
                          data-id="<?= $row['id'] ?>"
                          data-code="<?= htmlspecialchars($row['code']) ?>">
                    <i class="bi bi-pencil"></i>
                  </button>
                  <a href="?hapus=<?= $row['id'] ?>" class="btn btn-danger btn-sm"
                     onclick="return confirm('Yakin ingin hapus kode ini?');">
                    <i class="bi bi-trash"></i>
                  </a>
                </div>
              </td>
            </tr>
            <?php endwhile; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<footer>© 2025 ZoKids — Edukasi Anak Indonesia</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.addEventListener("DOMContentLoaded", function() {
  const editBtns = document.querySelectorAll(".editBtn");
  const kodeInput = document.getElementById("kode_input");
  const kodeId = document.getElementById("kode_id");
  const submitBtn = document.getElementById("submitBtn");
  const editButtons = document.getElementById("editButtons");
  const cancelBtn = document.getElementById("cancelEdit");

  editBtns.forEach(btn => {
    btn.addEventListener("click", () => {
      const id = btn.dataset.id;
      const code = btn.dataset.code;

      kodeInput.value = code;
      kodeId.value = id;

      // Ubah tombol tambah jadi simpan & batal
      submitBtn.classList.add("d-none");
      editButtons.classList.remove("d-none");
    });
  });

  cancelBtn.addEventListener("click", () => {
    kodeInput.value = "";
    kodeId.value = "";
    submitBtn.classList.remove("d-none");
    editButtons.classList.add("d-none");
  });
});
</script>
</body>
</html>
