<?php
session_start();
if (!isset($_SESSION['admin'])) {
  header("Location: login.php");
  exit;
}

include "../config/db.php";
$message = "";

/* ============ TAMBAH KATEGORI ============ */
if (isset($_POST['tambah'])) {
  $nama = trim($_POST['nama_kategori'] ?? '');
  if ($nama === '') {
    $message = "Nama kategori harus diisi.";
  } else {
    $iconName = null;
    if (!empty($_FILES['logo']['name'])) {
      $uploadDir = "../assets/icons/";
      if (!is_dir($uploadDir)) mkdir($uploadDir, 0755, true);
      $iconName = time() . "_" . preg_replace('/[^A-Za-z0-9_.-]/', '_', basename($_FILES['logo']['name']));
      $target = $uploadDir . $iconName;
      if (!move_uploaded_file($_FILES['logo']['tmp_name'], $target)) {
        $message = "Gagal upload icon.";
        $iconName = null;
      }
    }
    $colors = ["#FF6B6B", "#4ECDC4", "#45B7D1", "#FFA502", "#7D5FFF", "#2ED573"];
    $randomColor = $colors[array_rand($colors)];
    $stmt = $conn->prepare("INSERT INTO kategori (nama_kategori, icon, color) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $nama, $iconName, $randomColor);
    $stmt->execute();
    $message = "Kategori <b>$nama</b> berhasil ditambahkan.";
  }
}

/* ============ HAPUS KATEGORI ============ */
if (isset($_GET['hapus'])) {
  $id = intval($_GET['hapus']);
  $sel = $conn->prepare("SELECT icon FROM kategori WHERE id = ?");
  $sel->bind_param("i", $id);
  $sel->execute();
  $res = $sel->get_result();
  if ($res && $row = $res->fetch_assoc()) {
    $iconFile = $row['icon'];
    if ($iconFile && file_exists("../uploads/icons/" . $iconFile)) {
      @unlink("../uploads/icons/" . $iconFile);
    }
  }
  $del = $conn->prepare("DELETE FROM kategori WHERE id=?");
  $del->bind_param("i", $id);
  $del->execute();
  $message = "Kategori berhasil dihapus.";
}

/* ============ UPDATE KATEGORI ============ */
if (isset($_POST['update_kategori'])) {
  $id = intval($_POST['id']);
  $nama = trim($_POST['nama_kategori'] ?? '');
  $color = trim($_POST['warna'] ?? '');
  $iconName = $_POST['icon_lama'] ?? '';

  if (!empty($_FILES['logo']['name'])) {
    $uploadDir = "../assets/icons/";
    if (!is_dir($uploadDir)) mkdir($uploadDir, 0755, true);
    $newIcon = time() . "_" . preg_replace('/[^A-Za-z0-9_.-]/', '_', basename($_FILES['logo']['name']));
    $target = $uploadDir . $newIcon;
    if (move_uploaded_file($_FILES['logo']['tmp_name'], $target)) {
      if ($iconName && file_exists($uploadDir . $iconName)) {
        @unlink($uploadDir . $iconName);
      }
      $iconName = $newIcon;
    }
  }

  $stmt = $conn->prepare("UPDATE kategori SET nama_kategori=?, icon=?, color=? WHERE id=?");
  $stmt->bind_param("sssi", $nama, $iconName, $color, $id);
  $stmt->execute();
  $message = "Kategori <b>$nama</b> berhasil diperbarui.";
}

/* ============ EDIT MODE ============ */
$editData = null;
if (isset($_GET['edit'])) {
  $id = intval($_GET['edit']);
  $res = $conn->query("SELECT * FROM kategori WHERE id=$id");
  $editData = $res->fetch_assoc();
}

$kategori = $conn->query("SELECT * FROM kategori ORDER BY id ASC");
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Kelola Kategori - ZoKids</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
  <link rel="stylesheet" href="/edukasi_anak/assets/css/style1.css">
  <style>
    input[type=color] { padding: 0.2rem; height: 42px; cursor: pointer; }
  </style>
</head>
<body class="dashboard">

<!-- Navbar -->
<div class="navbar-zokids">
  <div class="brand"><h1>ZoKids Admin</h1></div>
  <a href="dashboard.php" class="btn btn-secondary"><i class="bi bi-box-arrow-left"></i></a>
</div>

<!-- Konten -->
<div class="dashboard-container">
  <div class="container">
    <h4 class="mb-3">Kelola Kategori</h4>

    <?php if ($message): ?>
      <div class="alert alert-info shadow-sm rounded-3"><?= $message ?></div>
    <?php endif; ?>

    <!-- Form Tambah / Edit -->
    <div class="card p-3 mb-4 bg-light bg-opacity-75 rounded-4">
      <form method="post" enctype="multipart/form-data" class="text-start">
        <input type="hidden" name="id" value="<?= $editData['id'] ?? '' ?>">
        <?php if ($editData): ?>
          <input type="hidden" name="icon_lama" value="<?= htmlspecialchars($editData['icon'] ?? '') ?>">
        <?php endif; ?>

        <div class="mb-3">
          <label class="form-label fw-semibold text-start w-100">Nama Kategori</label>
          <input type="text" name="nama_kategori" class="form-control rounded-3" required
                value="<?= htmlspecialchars($editData['nama_kategori'] ?? '') ?>">
        </div>

        <div class="mb-3">
          <label class="form-label fw-semibold text-start w-100">Warna</label><br>
          <input type="color" name="warna" class="form-control-color rounded border-0"
                value="<?= htmlspecialchars($editData['color'] ?? '#00c9a7') ?>" style="width:60px;height:60px;">
        </div>

        <div class="mb-3">
          <label class="form-label fw-semibold text-start w-100">Logo / Icon</label>
          <?php if ($editData && $editData['icon']): ?>
            <img src="../assets/icons/<?= $editData['icon'] ?>" width="80" class="rounded mb-2"><br>
          <?php endif; ?>
          <input type="file" name="logo" class="form-control rounded-3">
        </div>

        <?php if ($editData): ?>
          <div class="d-flex justify-content-center gap-2 mt-3">
            <button type="submit" name="update_kategori" class="btn btn-primary rounded-3 px-4 py-2">
              <i class="bi bi-save"></i> Save
            </button>
            <a href="kategori.php" class="btn btn-secondary rounded-3 px-4 py-2">
              <i class="bi bi-x-circle"></i> Batal
            </a>
          </div>
        <?php else: ?>
          <div class="text-center mt-3">
            <button type="submit" name="tambah" class="btn btn-primary rounded-3 px-4 py-2" style="width:auto;">
              <i class="bi bi-plus-circle"></i> Tambah
            </button>
          </div>
        <?php endif; ?>
      </form>
    </div>

    <!-- Tabel kategori -->
    <div class="card bg-white bg-opacity-75 rounded-4 p-3 shadow-sm">
      <div class="table-responsive">
        <table class="table table-bordered align-middle text-center mb-0">
          <thead class="table-warning">
            <tr>
              <th style="width: 60px;">No</th>
              <th>Icon</th>
              <th>Nama</th>
              <th>Warna</th>
              <th style="width: 110px;">Aksi</th>
            </tr>
          </thead>
          <tbody>
            <?php 
            $no = 1;
            while ($row = $kategori->fetch_assoc()): ?>
              <tr>
                <td><?= $no++; ?></td>
                <td style="width:90px">
                  <?php if (!empty($row['icon']) && file_exists("../assets/icons/" . $row['icon'])): ?>
                    <img src="../assets/icons/<?= htmlspecialchars($row['icon']) ?>" alt="icon" style="height:48px;border-radius:8px;">
                  <?php else: ?><span class="text-muted small">no icon</span><?php endif; ?>
                </td>
                <td><?= htmlspecialchars($row['nama_kategori']) ?></td>
                <td>
                  <div style="width:60px;height:20px;background:<?= htmlspecialchars($row['color']) ?>;border-radius:4px;margin:auto;"></div>
                </td>
                <td>
                  <div class="d-flex justify-content-center flex-wrap gap-1">
                    <a href="?edit=<?= $row['id']; ?>" class="btn btn-warning btn-sm d-flex align-items-center justify-content-center" title="Edit">
                      <i class="bi bi-pencil"></i>
                    </a>
                    <a href="?hapus=<?= $row['id']; ?>" class="btn btn-danger btn-sm d-flex align-items-center justify-content-center" title="Hapus"
                      onclick="return confirm('Yakin ingin hapus?');">
                      <i class="bi bi-trash"></i>
                    </a>
                  </div>
                </td>
              </tr>
            <?php endwhile; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<footer>© 2025 ZoKids — Edukasi Anak Indonesia</footer>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
